/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *	             GNU/linux version 3.4.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2004,2005,2006,2007,2008,2009,2012,2018 COLLARD Christophe
 * copyright © 2004,2005,2006,2007,2008,2009,2012,2018 Centre National de la Recherche Scientifique
 * copyright © 2004,2005,2006,2007,2008,2009 Arts et Métiers ParisTech
 * copyright © 2004,2005,2006,2007 Université de Valenciennes et du Hainaut-Cambrésis
 * copyright © 2004,2005,2006,2007,2008,2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2004,2005,2006,2007 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV)
 * copyright © 2012,2018 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    combinatorial analystis-test belongs to Mathematical Object Libraries (MOL++)
    MOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for combinatorial analysis-test
#endif

#ifndef __combinatorial_analysis_test_hpp
#define __combinatorial_analysis_test_hpp


#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __time_h
#include <time.h>
#endif

#ifndef __colors_hpp
#include "colors.hpp"
#endif

#ifndef __vectors_hpp
#include "MOL++/vectors.hpp"
#endif

#ifndef __matrix_hpp
#include "MOL++/matrix.hpp"
#endif

#ifndef __combinatorial_analysis_hpp
#include "MOL++/combinatorial analysis.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace mol;


//==========================================
int test_combinatorial_analysis (int detail)
//==========================================
{
  int result=1;

  if (detail) affiche ("Cnp", Cnp(24,6)==134596 && Cnp(24,1)==24);
  else result *= (Cnp(24,6)==134596 && Cnp(24,1)==24);

  vector<int> v(7);
  for (int i=1; i<=7; i++)
    v[i] = i;
  matrix <int> mat(21,5);
  mat(1,1)=1; mat(1,2)=2; mat(1,3)=3; mat(1,4)=4; mat(1,5)=5;
  mat[2] = mat[1];  mat(2,5) = 6;
  mat[3] = mat[1];  mat(3,5) = 7;
  mat[4] = mat[1];  mat(4,5) = 6;  mat(4,4) = 5;
  mat[5] = mat[4];  mat(5,5) = 7;
  mat[6] = mat[5];  mat(6,4) = 6;
  mat[7] = mat[4];  mat(7,3) = 4;
  mat[8] = mat[7];  mat(8,5) = 7;
  mat[9] = mat[8];  mat(9,4) = 6;
  mat[10] = mat[9]; mat(10,3) = 5;
  mat[11] = mat[7]; mat(11,2) = 3;
  mat[12] = mat[11]; mat(12,5) = 7;
  mat[13] = mat[12]; mat(13,4) = 6;
  mat[14] = mat[13]; mat(14,3) = 5;
  mat[15] = mat[14]; mat(15,2) = 4;
  mat[16] = mat[11]; mat(16,1) = 2;
  mat[17] = mat[16]; mat(17,5) = 7;
  mat[18] = mat[17]; mat(18,4) = 6;
  mat[19] = mat[18]; mat(19,3) = 5;
  mat[20] = mat[19]; mat(20,2) = 4;
  mat[21] = mat[20]; mat(21,1) = 3;

  if (detail) affiche ("combinations", mat==combinations (5,v));
  else result *= (mat==combinations (5,v));

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout << green << "            combinatorial analysis test passed" << reset;
  else cout << red << "            combinatorial analysis test failed" << reset;
  cout << "============================================================== \n";
  return result;
}


#endif
